IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CPJ_Cbtes_Fac_Generar_Item') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CPJ_Cbtes_Fac_Generar_Item
END
GO


CREATE PROCEDURE [dbo].[CPJ_Cbtes_Fac_Generar_Item]		@pJson VARCHAR(8000)
AS 
SET NOCOUNT ON 

/*
 * LOG VERSIONES:
 * 13/09/2021: Se agrego Log de Versiones
 * 10/06/2022: Se cambia que Costo_MO siempre lo tome de la tabla de Productos y omita @pCosto_MO por pedido de Victor
*/

/*Variables recibidas por parametro a traves del JSON*/
DECLARE @pFlagUsarTrans								TINYINT
DECLARE @pModoDebug									TINYINT
DECLARE @pId_Trans									INT
DECLARE @pId_Producto								VARCHAR(14)
DECLARE @pCantidad									DECIMAL(15,5)
DECLARE @pFecha_QA									DATETIME
DECLARE @pFecha_Venc								DATETIME
DECLARE @pId_Cliente								INT
DECLARE @pBonif										DECIMAL(5,2)
DECLARE @pPrecio_Grav								DECIMAL(15,5)
DECLARE @pPrecio_Exen								DECIMAL(15,5)
DECLARE @pId_Tiempo									CHAR(3)
DECLARE @pRefacturar								TINYINT
DECLARE @pFlag_Tabla_Temp							TINYINT
DECLARE @pLote										VARCHAR(20)
DECLARE @pFecha_Entrega								DATETIME
DECLARE @pCosto_GF									DECIMAL(15,5)
DECLARE @pCosto_MO									DECIMAL(15,5)
DECLARE @pRedondeo_Imp_Final						TINYINT
DECLARE @pCantidad_Equiv							DECIMAL(15,5)
DECLARE @pOmitir_Resultado_OK						TINYINT	
DECLARE @pFlag_Verif_Prod_Fact_x_Contrato			TINYINT	 -- 31/8

SET @pFlag_Tabla_Temp								= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Flag_Tabla_Temp')), 0)
SET @pFlagUsarTrans									= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug										= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Producto									= ISNULL(CONVERT(VARCHAR(14), dbo.CF_JSON_VALUE(@pJson,'Id_Producto')), 0)
SET @pCantidad										= ISNULL(CONVERT(DECIMAL(15,5), dbo.CF_JSON_VALUE(@pJson,'Cantidad')), 0)
SET @pFecha_QA										= CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_QA'))
SET @pFecha_Venc									= CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Venc'))
SET @pId_Cliente									= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Cliente')), 0)
SET @pBonif											= ISNULL(CONVERT(DECIMAL(5,2), dbo.CF_JSON_VALUE(@pJson,'Bonif')), 0)
SET @pPrecio_Grav 									= ISNULL(CONVERT(DECIMAL(15,5), dbo.CF_JSON_VALUE(@pJson,'Precio_Grav')), 0)
SET @pPrecio_Exen									= ISNULL(CONVERT(DECIMAL(15,5), dbo.CF_JSON_VALUE(@pJson,'Precio_Exen')), 0)
SET @pId_Tiempo	            						= ISNULL(CONVERT(CHAR(3), dbo.CF_JSON_VALUE(@pJson,'Id_Tiempo')), '')
SET @pRefacturar									= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Refacturar')), 0)
SET @pId_Trans										= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Trans')), 0)
SET @pLote											= ISNULL(CONVERT(VARCHAR(20), dbo.CF_JSON_VALUE(@pJson,'Lote')), '')
SET @pFecha_Entrega									= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Entrega')), '19000101')
SET @pCosto_GF										= ISNULL(CONVERT(DECIMAL(15,5), dbo.CF_JSON_VALUE(@pJson,'Costo_GF')), 0)
SET @pCosto_MO										= ISNULL(CONVERT(DECIMAL(15,5), dbo.CF_JSON_VALUE(@pJson,'Costo_MO')), 0)
SET @pRedondeo_Imp_Final							= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Redondeo_Imp_Final')), 0)
SET @pCantidad_Equiv     							= ISNULL(CONVERT(DECIMAL(15,5), dbo.CF_JSON_VALUE(@pJson,'Cantidad_Equiv')), 0)
SET @pOmitir_Resultado_OK							= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Omitir_Resultado_OK')), 0)
SET @pFlag_Verif_Prod_Fact_x_Contrato				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Flag_Verif_Prod_Fact_x_Contrato')), 0)
/*FIN Variables recibidas por parametro a traves del JSON*/

/*Variable de Retorno del Stored*/
DECLARE @rtaErrorStored			INT
DECLARE @rtaMsjStored			VARCHAR(4000)
/*FIN Variable de Retorono del Stored*/

/*Declaracion Variables Locales*/
DECLARE @Item 					SMALLINT
DECLARE @Id_Estado_Cbte 		SMALLINT
DECLARE @Calle 					CHAR(5)
DECLARE @Columna 				CHAR(5)
DECLARE @Fila 					CHAR(5)
DECLARE @Bultos 				DECIMAL(15, 5)
DECLARE @Despacho 				VARCHAR(100)
DECLARE @Serie 					VARCHAR(100)
DECLARE @Millas 				INT
DECLARE @Cantidad_Saldo 		DECIMAL(15, 5)
DECLARE @Imp_Gravado 			DECIMAL(12, 2)
DECLARE @Imp_Exento 			DECIMAL(12, 2)
DECLARE @Analisis 				VARCHAR(30)
DECLARE @Flag_QA 				CHAR(1)
DECLARE @Descripcion_producto 	VARCHAR(100)
DECLARE @Id_Unidad_Medida 		CHAR(4)
DECLARE @Imp_Final				DECIMAL(15,5)
DECLARE @Costo 					DECIMAL(15, 5)
DECLARE @Imp_Iva 				DECIMAL(12, 2)
DECLARE @Id_Costo 				INT
DECLARE @Id_Tarea 				SMALLINT
DECLARE @Fecha_Caducidad 		DATETIME
DECLARE @Id_Pais 				CHAR(3)
DECLARE @Id_Usuario 			SMALLINT
DECLARE @Cantidad_Equiv 		DECIMAL(15, 5)
DECLARE @Costo_MO 				DECIMAL(15, 5)
DECLARE @Costo_GF 				DECIMAL(15, 5)
DECLARE @Id_Cond_Pago 			SMALLINT
DECLARE @Fecha_Proceso 			DATETIME
DECLARE @Id_Balanza 			CHAR(10)
DECLARE @Orden 					SMALLINT
DECLARE @Flag_NoImp_Factura 	TINYINT
DECLARE @Nro_Tag 				VARCHAR(30)
DECLARE @Fecha_Elaboracion 		DATETIME
DECLARE @Costo_Comparativo 		DECIMAL(13, 4)
DECLARE @Porc_Imp_Int 			DECIMAL(5, 2)
DECLARE @Id_Cta_Banco 			SMALLINT
DECLARE @Flag_Existe_Trans		TINYINT
DECLARE @Flag_Existe_Cliente	TINYINT
DECLARE @Flag_Existe_Producto	TINYINT
DECLARE @Observacion			VARCHAR(8000)
DECLARE @Id_Lista_Precio		SMALLINT
DECLARE @Precio_Gravado_Producto DECIMAL(13, 4)
DECLARE @Precio					DECIMAL(15,5)
DECLARE @Item_Facturado         SMALLINT
DECLARE @Id_Iva					CHAR(3)
DECLARE @Porc1					DECIMAL(7,4)
DECLARE @Tasa_Iva_1				DECIMAL(12,2)
DECLARE @Tasa_Iva_2				DECIMAL(12,2)
DECLARE @Tasa_Iva_3				DECIMAL(12,2)
DECLARE @Porc_Iva				DECIMAL(5,2)		
DECLARE @Precio_Exen			DECIMAL(15,5)
DECLARE @Precio_Grav			DECIMAL(15,5)
DECLARE @Costo_Rentabilidad		DECIMAL(13,4)			--09/09/2021 Agregado
DECLARE @Cantidad		INT
DECLARE @Tipo			CHAR(1)
DECLARE @CantCiclos		INT
DECLARE @Flag_Mes		TINYINT
DECLARE @Flag_Periodo	TINYINT
/*FIN Declaracion Variables Locales*/

IF @pFlagUsarTrans <> 0 AND @@TRANCOUNT > 0 
	SET @pFlagUsarTrans = 0

BEGIN TRY
 
	IF @pFlagUsarTrans <> 0 
	BEGIN
		BEGIN TRAN
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Cbtes_Fac_Generar_Item'
		PRINT 'Parametros:'
		PRINT 'FlagUsarTrans: ' + CONVERT(VARCHAR(10), @pFlagUsarTrans) + ' Id_Trans: ' + CONVERT(VARCHAR(10), @pId_Trans) + ' Id_Producto: ' + @pId_Producto + ' Cantidad: ' + CONVERT(VARCHAR(10), @pCantidad) + ' Fecha_QA: ' + CONVERT(VARCHAR(10), @pFecha_QA, 103) + ' Fecha_Venc: ' + CONVERT(VARCHAR(10), @pFecha_Venc, 103) + ' Id_Cliente: ' + CONVERT(VARCHAR(10), @pId_Cliente) + ' Bonif: ' + CONVERT(VARCHAR(10), @pBonif) + ' Precio_Grav: ' + CONVERT(VARCHAR(25), @pPrecio_Grav) + ' Precio_Exent: ' + CONVERT(VARCHAR(25), @pPrecio_Exen) 
	END

	/*===================================================================*/
    IF @pFlag_Tabla_Temp = 1
	BEGIN
		SET @pId_Trans	= 0
	END
	ELSE
	BEGIN
    	IF(@pId_Trans = 0)		RAISERROR ('Id_Trans can not be zero.', 16,  1 ) 
	END

	IF(@pId_Cliente = 0)	RAISERROR ('Id_Cliente can not be zero.', 16,  1 )
	IF(@pId_Producto = '')	RAISERROR ('Id_Producto can not be blank.', 16,  1 ) 
	
	SELECT @Flag_Mes = Flag_Mes, @Flag_Periodo = Flag_Periodo FROM Productos WHERE Id_Producto = @pId_Producto
    
	SET @Item_Facturado = 0

	IF @pRefacturar = 0 
	BEGIN
		IF @pFlag_Tabla_Temp = 1 AND OBJECT_ID (N'Z_CONTRATOS_FACTURADOS', N'U') IS NOT NULL 
		BEGIN
			SET @Item_Facturado = ISNULL((select 1 from Z_CONTRATOS_FACTURADOS WHERE id_Cliente  = @pId_Cliente AND Id_Producto = @pId_Producto),0)
		END

	   	IF(@Item_Facturado = 0 AND @pFlag_Verif_Prod_Fact_x_Contrato = 0) -- 31/8
		BEGIN
    		IF @pId_Tiempo <> '' AND @Flag_Mes <> 1   --por defecto se toma mensual
			BEGIN

				SELECT @Cantidad = ISNULL(Cantidad,0), @Tipo = ISNULL(Tipo,0) FROM Tab_Uni_Tiempo WHERE Id_Tiempo = @pId_Tiempo
				IF @Cantidad = 0 SET @Cantidad = 1

				IF @Tipo = 'A'
					SELECT @CantCiclos = ISNULL(  DATEDIFF(yy,MAX(i.Fecha_QA),@pFecha_QA) ,9999999) 
							FROM Cbtes_Items i, Cbtes c , Cbtes_Tipos T 
							WHERE c.id_trans = i.id_trans 
									AND T.Id_Tipo_Cbte = C.Id_Tipo_Cbte 
									AND ((c.Comprobante_Nro = 0 AND c.Id_Estado_Cbte = 3) OR c.Id_Estado_Cbte NOT IN (0,3))
									AND (T.Compromete_Factura = 1 OR T.Compromete_Remitos = 1)
									AND I.Id_Cliente = @pId_Cliente
									AND i.Id_Producto = @pId_Producto
				ELSE IF @Tipo = 'D'
					SELECT @CantCiclos = ISNULL(  DATEDIFF(dd,MAX(i.Fecha_QA),@pFecha_QA) ,9999999) 
							FROM Cbtes_Items i, Cbtes c , Cbtes_Tipos T 
							WHERE c.id_trans = i.id_trans 
									AND T.Id_Tipo_Cbte = C.Id_Tipo_Cbte 
									AND ((c.Comprobante_Nro = 0 AND c.Id_Estado_Cbte = 3) OR c.Id_Estado_Cbte NOT IN (0,3))
									AND (T.Compromete_Factura = 1 OR T.Compromete_Remitos = 1)
									AND I.Id_Cliente = @pId_Cliente
									AND i.Id_Producto = @pId_Producto	
				ELSE		
					SELECT @CantCiclos = ISNULL(  DATEDIFF(mm,MAX(i.Fecha_QA),@pFecha_QA) ,9999999) 
							FROM Cbtes_Items i, Cbtes c , Cbtes_Tipos T 
							WHERE c.id_trans = i.id_trans 
									AND T.Id_Tipo_Cbte = C.Id_Tipo_Cbte 
									AND ((c.Comprobante_Nro = 0 AND c.Id_Estado_Cbte = 3) OR c.Id_Estado_Cbte NOT IN (0,3))
									AND (T.Compromete_Factura = 1 OR T.Compromete_Remitos = 1)
									AND I.Id_Cliente = @pId_Cliente
									AND i.Id_Producto = @pId_Producto	

				IF @CantCiclos < @Cantidad SET @Item_Facturado = 1
			END
			ELSE   --IF ISNULL(@pId_Tiempo,'') <> ''   -
			BEGIN
				IF @Flag_Mes = 1 OR @Flag_Periodo = 1
				BEGIN
					IF @pFlag_Tabla_Temp = 1 AND OBJECT_ID (N'Z_Productos_Facturados', N'U') IS NOT NULL 
					BEGIN
							SELECT  @Item_Facturado = 1 FROM Z_Productos_Facturados WHERE Id_Producto = @pId_Producto AND Id_Cliente = @pId_Cliente
					END
					ELSE
					BEGIN
						SELECT  @Item_Facturado = 1 FROM Cbtes_Items i, Cbtes c , Cbtes_Tipos T 
									WHERE c.id_trans = i.id_trans 
												AND T.Id_Tipo_Cbte = C.Id_Tipo_Cbte 
												AND ((c.Comprobante_Nro = 0 AND c.Id_Estado_Cbte = 3) 
												OR c.Id_Estado_Cbte NOT IN (0,3))
												AND (T.Compromete_Factura = 1 OR T.Compromete_Remitos = 1)
												AND ISNULL(I.Id_Cliente,C.ID_CLIENTE) = @pId_Cliente
												AND i.Id_Producto = @pId_Producto
												AND DATEPART(yy,i.Fecha_QA) = DATEPART(yy,@pFecha_QA) 
												AND DATEPART(mm,i.Fecha_QA) = DATEPART(mm,@pFecha_QA) 
					END
				END
			END
		END
	END

    IF (@pRefacturar = 0 AND @Item_Facturado <> 0)
	BEGIN
		IF @pFlagUsarTrans <> 0 COMMIT

		/*************************************************************************************************/
		IF @pOmitir_Resultado_OK = 0
		BEGIN
			SET @rtaMsjStored		=	'{' +
										dbo.CF_Json_ParsearVariable('id_trans', ISNULL(@pId_Trans,0), 'INT')  + ',' +
										dbo.CF_Json_ParsearVariable('item', ISNULL(@Item,0), 'SMALLINT')  + ',' +
										dbo.CF_Json_ParsearVariable('id_producto', ISNULL(@pId_Producto,''), 'VARCHAR')  + ',' +
										dbo.CF_Json_ParsearVariable('imp_final', ISNULL(@Imp_Final,0), 'DECIMAL') +
										'}'

			SELECT	 0				AS ErrorNumber 
					,0				AS ErrorSeverity  
					,0				AS ErrorState 
					,0				AS ErrorProcedure  
					,0				AS ErrorLine		
					,@rtaMsjStored	AS ErrorMessage
		END
		RETURN 0
	END


	/*************************************************************************************************/

	SET @Tasa_Iva_1	= CONVERT(DECIMAL(12,2), dbo.CF_xParam('Tasa_Iva_1'))
	SET @Tasa_Iva_2	= CONVERT(DECIMAL(12,2), dbo.CF_xParam('Tasa_Iva_2'))
	SET @Tasa_Iva_3	= CONVERT(DECIMAL(12,2), dbo.CF_xParam('Tasa_Iva_3'))

	/*************************************************************************************************/

	SELECT  
	@Id_Estado_Cbte	= ISNULL(Id_Estado_Cbte, 0),
	@pLote			= ISNULL(Lote, ''),
	@Id_Usuario		= ISNULL(Id_Usuario, '-1')
	FROM Cbtes
	WHERE 
	Id_Trans = @pId_Trans

	/*************************************************************************************************/

	SELECT  
	@Calle					= ISNULL(Calle, ''),
	@Columna				= ISNULL(Columna, ''),
	@Fila					= ISNULL(Fila, ''),
	@Despacho				= ISNULL(Despacho, ''),
	@Descripcion_producto	= ISNULL(Descripcion_Resumida, ''),
	@Id_Unidad_Medida		= ISNULL(Id_Unidad_Medida, ''),
	@Costo					= ISNULL(Costo, 0),
	@Id_Cond_Pago			= ISNULL(Id_Cond_Pago, 0),
	@Id_Cta_Banco			= ISNULL(Id_Cta_Banco, 0),
	@Precio_Gravado_Producto = ISNULL(Precio_Gravado, 0),
	@Id_Iva					= ISNULL(Id_Iva, ''),
	@Costo_Rentabilidad		= ISNULL(Costo_Rentabilidad, 0),
	@Costo_mo		        = ISNULL(Costo_Rentabilidad, 0)
	FROM Productos
	WHERE 
	Id_Producto = @pId_Producto	
	

	/*************************************************************************************************/

	SELECT
	@Porc1	= ISNULL(Porc1, 0)
	FROM Productos_TasaIva
	WHERE
	Id_Iva = @Id_Iva
	
	SET @Porc_Iva = @Porc1


	/*************************************************************************************************/
		
	--EXENTO
	IF(@pBonif > 0)
	BEGIN
		SET @Precio_Exen			= @pPrecio_Exen * (1 - (@pBonif / 100))
	END
	ELSE
	BEGIN
		SET @Precio_Exen			= @pPrecio_Exen
	END

	SET @Imp_Exento				= @Precio_Exen * @pCantidad	

	-------------------------------------------------------------------------------------

	--GRAVADO
	IF(@pBonif > 0)
	BEGIN
		SET @Precio_Grav			= @pPrecio_Grav * (1 - (@pBonif / 100))
	END
	ELSE
	BEGIN
		SET @Precio_Grav			= @pPrecio_Grav
	END

	SET @Imp_Gravado			= @Precio_Grav * @pCantidad
	SET @Imp_Iva 				= @Imp_Gravado * (@Porc_Iva/100)

	-------------------------------------------------------------------------------------

	SET @Precio		= @Precio_Exen + @Precio_Grav 

	SET @Imp_Final	= @Imp_Exento + @Imp_Gravado + @Imp_Iva

	IF(@pRedondeo_Imp_Final > 0)
	BEGIN
		SET @Imp_Final				= ROUND(@Imp_Final, @pRedondeo_Imp_Final)
	END

	/*************************************************************************************************/

	IF @pFlag_Tabla_Temp = 1
	BEGIN
    	SET @Item 					= (ISNULL((SELECT MAX(ISNULL(Item, 0)) FROM #ITEMS_CBTE WHERE Id_Trans = @pId_Trans), 0)) + 1
	END
	ELSE
	BEGIN
     	SET @Item 					= (ISNULL((SELECT MAX(ISNULL(Item, 0)) FROM CBTES_ITEMS WHERE Id_Trans = @pId_Trans), 0)) + 1
	END


	SET @Bultos 				= 0
	SET @Serie 					= ''
	SET @Millas 				= 0
	SET @Cantidad_Saldo 		= @pCantidad
	SET @Analisis 				= ''
	SET @Flag_QA 				= 'A'
	SET @Id_Costo 				= 0
	SET @Id_Tarea 				= 0
	SET @Fecha_Caducidad 		= NULL
	SET @Id_Pais 				= ''
	SET @Cantidad_Equiv 		= @pCantidad_Equiv

    SET @Costo_GF 				= @pCosto_GF
	SET @Fecha_Proceso 			= NULL
	SET @Id_Balanza 			= ''
	SET @Orden 					= 0
	SET @Flag_NoImp_Factura 	= 0
	SET @Nro_Tag 				= ''
	SET @Fecha_Elaboracion 		= NULL
	SET @Costo_Comparativo 		= 0
	SET @Porc_Imp_Int 			= 0
	SET @Observacion			= (ISNULL((SELECT Observa_Factura FROM Productos WHERE Id_Producto = @pId_Producto), ''))

	/*************************************************************************************************/

	IF((@pFecha_Entrega <> '19000101') AND (CONVERT(DATE, @pFecha_Entrega) <> CONVERT(DATE, GETDATE())))
	BEGIN
		UPDATE Cbtes 
		SET
		Fecha_Estimada = @pFecha_Entrega
		WHERE
		Id_Trans = @pId_Trans
	END

	/*************************************************************************************************/

	IF @pFlag_Tabla_Temp = 1
	BEGIN
		INSERT INTO #ITEMS_CBTE
		(Id_Trans,		Item,					Id_Producto, 
		Id_Estado_Cbte, Cantidad,				Calle, 
		Columna,		Fila,					Bultos, 
		Despacho,		Serie,					Fecha_Venc,
		Observacion,	Millas,					Cantidad_Saldo, 
		Precio_Grav,	Precio_Exen,			Imp_Gravado, 
		Imp_Exento,		Analisis,				Lote, 
		Flag_QA,		Fecha_QA,				Porc_Iva, 
		Bonif,			Descripcion_producto,	Id_Unidad_Medida, 
		Imp_Final,		Costo,					Imp_Iva, 
		Precio,			Id_Costo,				Id_Cliente,
		Id_Tarea,		Fecha_Caducidad,		Id_Pais, 
		Id_Usuario,		Cantidad_Equiv,			Costo_MO, 
		Costo_GF,		Id_Cond_Pago,			Fecha_Proceso, 
		Id_Balanza,		Orden,					Flag_NoImp_Factura, 
		Nro_Tag,		Fecha_Elaboracion,		Costo_Comparativo, 
		Porc_Imp_Int,	Id_Cta_Banco)
		VALUES
		(@pId_Trans,		@Item,					@pId_Producto, 
		@Id_Estado_Cbte,	@pCantidad,				@Calle, 
		@Columna,			@Fila,					@Bultos, 
		@Despacho,			@Serie,					@pFecha_Venc,
		@Observacion,		@Millas,				@Cantidad_Saldo, 
		@Precio_Grav,		@Precio_Exen,			@Imp_Gravado, 
		@Imp_Exento,		@Analisis,				@pLote, 
		@Flag_QA,			@pFecha_QA,				@Porc_Iva, 
		@pBonif,			@Descripcion_producto,	@Id_Unidad_Medida, 
		@Imp_Final,			@Costo,					@Imp_Iva, 
		@Precio,			@Id_Costo,				@pId_Cliente,
		@Id_Tarea,			@Fecha_Caducidad,		@Id_Pais, 
		@Id_Usuario,		@Cantidad_Equiv,		@Costo_MO, 
		@Costo_GF,			@Id_Cond_Pago,			@Fecha_Proceso, 
		@Id_Balanza,		@Orden,					@Flag_NoImp_Factura, 
		@Nro_Tag,			@Fecha_Elaboracion,		@Costo_Comparativo, 
		@Porc_Imp_Int,		@Id_Cta_Banco)
	END
	ELSE
	BEGIN    
		INSERT INTO CBTES_ITEMS
		(Id_Trans,		Item,					Id_Producto, 
		Id_Estado_Cbte, Cantidad,				Calle, 
		Columna,		Fila,					Bultos, 
		Despacho,		Serie,					Fecha_Venc,
		Observacion,	Millas,					Cantidad_Saldo, 
		Precio_Grav,	Precio_Exen,			Imp_Gravado, 
		Imp_Exento,		Analisis,				Lote, 
		Flag_QA,		Fecha_QA,				Porc_Iva, 
		Bonif,			Descripcion_producto,	Id_Unidad_Medida, 
		Imp_Final,		Costo,					Imp_Iva, 
		Precio,			Id_Costo,				Id_Cliente,
		Id_Tarea,		Fecha_Caducidad,		Id_Pais, 
		Id_Usuario,		Cantidad_Equiv,			Costo_MO, 
		Costo_GF,		Id_Cond_Pago,			Fecha_Proceso, 
		Id_Balanza,		Orden,					Flag_NoImp_Factura, 
		Nro_Tag,		Fecha_Elaboracion,		Costo_Comparativo, 
		Porc_Imp_Int,	Id_Cta_Banco)
	    VALUES
		(@pId_Trans,		@Item,					@pId_Producto, 
		@Id_Estado_Cbte,	@pCantidad,				@Calle, 
		@Columna,			@Fila,					@Bultos, 
		@Despacho,			@Serie,					@pFecha_Venc,
		@Observacion,		@Millas,				@Cantidad_Saldo, 
		@Precio_Grav,		@Precio_Exen,			@Imp_Gravado, 
		@Imp_Exento,		@Analisis,				@pLote, 
		@Flag_QA,			@pFecha_QA,				@Porc_Iva, 
		@pBonif,			@Descripcion_producto,	@Id_Unidad_Medida, 
		@Imp_Final,			@Costo,					@Imp_Iva, 
		@Precio,			@Id_Costo,				@pId_Cliente,
		@Id_Tarea,			@Fecha_Caducidad,		@Id_Pais, 
		@Id_Usuario,		@Cantidad_Equiv,		@Costo_MO, 
		@Costo_GF,			@Id_Cond_Pago,			@Fecha_Proceso, 
		@Id_Balanza,		@Orden,					@Flag_NoImp_Factura, 
		@Nro_Tag,			@Fecha_Elaboracion,		@Costo_Comparativo, 
		@Porc_Imp_Int,		@Id_Cta_Banco)
	END

	/*===================================================================*/
	
	IF @pFlagUsarTrans <> 0 
	BEGIN
		COMMIT
	END

	/*===================================================================*/	

	IF @pOmitir_Resultado_OK = 0
	BEGIN
		SET @rtaMsjStored		=	'{' +
									dbo.CF_Json_ParsearVariable('id_trans', @pId_Trans, 'INT')  + ',' +
									dbo.CF_Json_ParsearVariable('item',@Item, 'SMALLINT')  + ',' +
									dbo.CF_Json_ParsearVariable('id_producto', @pId_Producto, 'VARCHAR')  + ',' +
									dbo.CF_Json_ParsearVariable('imp_final',@Imp_Final, 'DECIMAL') +
									'}'

		SELECT	 0				AS ErrorNumber 
				,0				AS ErrorSeverity  
				,0				AS ErrorState 
				,0				AS ErrorProcedure  
				,0				AS ErrorLine		
				,@rtaMsjStored	AS ErrorMessage
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_Cbtes_Fac_Generar_Item'
	END
	
END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	IF @pFlagUsarTrans <> 0 
	BEGIN
		ROLLBACK
	END

	RETURN 9999
END CATCH

RETURN 0 
